/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a numeric value and represents it as a percentage (e.g. progress bar)
 */
export declare class ProgressControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Progress, FieldComponentProps<FieldKey.Progress>> {
    /**
     * @deprecated
     * The font color of the HTML field */
    color?: string;
    currentProgressLabel?: string;
    maxProgressLabel?: string;
    areProgressLabelsHidden?: boolean;
}
//# sourceMappingURL=progress-control-object.d.ts.map