import * as React from 'react';
export function TextRenderer({ value, height, scale, setMetadataContent }) {
    const containerRef = React.useRef(null);
    const [decodedText, setDecodedText] = React.useState('');
    React.useEffect(() => {
        if (!value?.arrayBuffer) {
            setDecodedText('');
        }
        const text = new TextDecoder().decode(value?.arrayBuffer);
        setDecodedText(text);
        setMetadataContent({
            lineCount: text.split('\n').length,
            numberOfPages: 1,
        });
    }, [setMetadataContent, value]);
    return (React.createElement("div", { className: "e-preview-field-body", style: { height: `${height}px` } },
        React.createElement("div", { className: "e-preview-field-document-body e-preview-field-document-body-text", "data-testid": "e-preview-field-document-body" },
            React.createElement("div", { className: "e-preview-text-container", ref: containerRef },
                React.createElement("pre", { className: "e-preview-text-content", "data-testid": "e-preview-text-content", style: { fontSize: `${14 * scale}px` } }, decodedText)))));
}
//# sourceMappingURL=text-renderer.js.map