/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { PreviewControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class PreviewDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = PreviewControlObject;
    }
}
/**
 * Initializes the decorated member as a [Pdf]{@link PreviewControlObject} field with the provided properties
 *
 * @param properties The properties that the [Pdf]{@link PreviewControlObject} field will be initialized with
 */
export function previewField(properties) {
    return standardDecoratorImplementation(properties, PreviewDecorator, FieldKey.Preview);
}
export function previewFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=preview-decorator.js.map