/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { PreviewDecoratorProperties } from './preview-types';
/**
 * Initializes the decorated member as a [Pdf]{@link PreviewControlObject} field with the provided properties
 *
 * @param properties The properties that the [Pdf]{@link PreviewControlObject} field will be initialized with
 */
export declare function previewField<T extends ScreenExtension<T>>(properties: PreviewDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function previewFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<PreviewDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=preview-decorator.d.ts.map