/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds an image
 */
export declare class PreviewControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Preview, FieldComponentProps<FieldKey.Preview>> {
    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.)*/
    get height(): number | undefined;
    /** File name for downloaded files. If not set the component tries to figure out the extension and prefix it with `document`, e.g `document.pdf` */
    filename?: string;
    /** Explicit mime-type. If not set, the component would try to figure out the type from the content. */
    mimeType?: string;
    /** Whether the document can be downloaded. */
    canDownload?: boolean;
    /** Whether printing is enabled, please note this feature is not available for all file types. */
    canPrint?: boolean;
    /** Whether zooming is enabled */
    canZoom?: boolean;
    /** Whether the thumbnail bar is enabled, please note this feature is not available for all file types. */
    hasThumbnailBar?: boolean;
    /** Whether the pagination controls are displayed in the header. */
    hasPaginationControls?: boolean;
    /** Externally set loading state. If set to true, a loading bar is displayed even if the field has value */
    isLoading?: boolean;
    /** Default zoom level */
    defaultZoomLevel?: number;
    /** Whether the filename in the header should be hidden  */
    isFilenameHidden?: boolean;
}
//# sourceMappingURL=preview-control-object.d.ts.map