import * as React from 'react';
import { Document, Page, pdfjs, Thumbnail } from 'react-pdf';
import LoaderBar from 'carbon-react/esm/components/loader-bar';
import { calculatePageScrollTop, usePageIndex } from './preview-utils';
import { xtremConsole } from '../../../utils/console';
import 'react-pdf/dist/Page/AnnotationLayer.css';
import 'react-pdf/dist/Page/TextLayer.css';
pdfjs.GlobalWorkerOptions.workerSrc = new URL('pdf.worker.min.mjs', window.location.origin).toString();
const PAGES_SELECTOR = '.react-pdf__Page';
export function PdfRenderer({ height, isThumbnailBarVisible, scale, scrollPageIndex, setCurrentPage, setMetadataContent, value, }) {
    const [document, setDocument] = React.useState(null);
    const bodyRef = React.useRef(null);
    usePageIndex(bodyRef, PAGES_SELECTOR, scrollPageIndex, setCurrentPage);
    const onThumbnailClick = React.useCallback(({ pageIndex }) => {
        if (!bodyRef.current) {
            return;
        }
        const top = calculatePageScrollTop(bodyRef, PAGES_SELECTOR, pageIndex);
        bodyRef.current.scrollTo({ top, behavior: 'smooth' });
    }, []);
    const onFileLoaded = React.useCallback(async (loadedDocument) => {
        const metadata = await loadedDocument.getMetadata();
        const info = metadata?.info;
        setDocument(loadedDocument);
        setMetadataContent({
            pdfVersion: info?.PDFVersion,
            producingSoftware: info?.Producer,
            numberOfPages: loadedDocument.numPages,
        });
    }, [setMetadataContent]);
    const onLoadError = React.useCallback((error) => {
        xtremConsole.error('Error loading PDF file', error);
    }, []);
    const pages = React.useMemo(() => {
        const collector = [];
        if (document) {
            for (let i = 0; i < document?.numPages; i += 1) {
                collector.push(React.createElement(Page, { key: i, pageIndex: i, scale: scale }));
            }
        }
        return collector;
    }, [document, scale]);
    const thumbnails = React.useMemo(() => {
        const collector = [];
        if (document) {
            for (let i = 0; i < document?.numPages; i += 1) {
                collector.push(React.createElement(Thumbnail, { key: i, pageIndex: i, width: 150, onItemClick: onThumbnailClick }));
            }
        }
        return collector;
    }, [document, onThumbnailClick]);
    return (React.createElement(Document, { key: value.url, file: value.url, onLoadSuccess: onFileLoaded, onLoadError: onLoadError },
        !document && React.createElement(LoaderBar, { m: "32px", "data-testid": "e-preview-field-loader" }),
        document && (React.createElement("div", { className: "e-preview-field-body", style: { height: `${height}px` } },
            isThumbnailBarVisible && React.createElement("div", { className: "e-preview-field-thumbnails" }, thumbnails),
            React.createElement("div", { "data-testid": "e-preview-field-document-body", className: "e-preview-field-document-body", ref: bodyRef }, pages)))));
}
//# sourceMappingURL=pdf-renderer.js.map