import * as React from 'react';
import { useResizeObserver } from 'usehooks-ts';
export function ImageRenderer({ value, height, scale, setMetadataContent }) {
    const containerRef = React.useRef(null);
    const imageRef = React.useRef(null);
    const { width } = useResizeObserver({ ref: containerRef });
    const onImageLoad = React.useCallback(() => {
        if (!imageRef.current) {
            return;
        }
        setMetadataContent({
            resolution: `${imageRef.current.naturalWidth} x ${imageRef.current.naturalHeight}`,
            numberOfPages: 1,
        });
    }, [setMetadataContent]);
    const appliedWidth = React.useMemo(() => {
        return ((width || 64) - 64) * scale;
    }, [width, scale]);
    const appliedHeight = React.useMemo(() => {
        return `calc(${height} * ${scale})`;
    }, [height, scale]);
    return (React.createElement("div", { className: "e-preview-field-body", style: { height: `${height}px` } },
        React.createElement("div", { className: "e-preview-field-document-body", "data-testid": "e-preview-field-document-body" },
            React.createElement("div", { className: "e-preview-image-container", ref: containerRef },
                React.createElement("div", { className: "e-preview-image", "data-testid": "e-preview-image", style: { width: appliedWidth, height: appliedHeight, backgroundImage: `url(${value.url})` } }),
                React.createElement("img", { "aria-hidden": true, style: { display: 'none' }, src: value.url, onLoad: onImageLoad, ref: imageRef })))));
}
//# sourceMappingURL=image-renderer.js.map