import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedPreviewComponent = React.lazy(() => import('./preview-component'));
export function AsyncConnectedPreviewComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedPreviewComponent, { ...props })));
}
const PreviewComponent = React.lazy(() => import('./preview-component').then(c => ({ default: c.PreviewComponent })));
export function AsyncPreviewComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(PreviewComponent, { ...props })));
}
//# sourceMappingURL=async-preview-component.js.map