import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { PodControlObject } from './pod-control-object';
class PodDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = PodControlObject;
    }
}
/**
 * Initializes the decorated member as a [VitalPod]{@link VitalPodControlObject} field with the provided properties.
 *
 * @param properties The properties that the [VitalPod]{@link VitalPodControlObject} field will be initialized with.
 */
export function podField(properties) {
    return standardDecoratorImplementation(properties, PodDecorator, FieldKey.Pod);
}
export function podFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=pod-decorator.js.map