import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { PodDecoratorProperties } from './pod-types';
/**
 * Initializes the decorated member as a [VitalPod]{@link VitalPodControlObject} field with the provided properties.
 *
 * @param properties The properties that the [VitalPod]{@link VitalPodControlObject} field will be initialized with.
 */
export declare function podField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode>(properties: PodDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function podFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode>(properties: ChangeableOverrideDecoratorProperties<PodDecoratorProperties<Extend<T>, ReferencedItemType>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=pod-decorator.d.ts.map