var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { noop } from 'lodash';
import { lookupDialog } from '../../../service/dialog-service';
import { showToast } from '../../../service/toast-service';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { getStore } from '../../../redux';
import { setFieldValue } from '../../../redux/actions';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export class PodControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        ...EditableFieldControlObject.defaultUiProperties,
    }; }
    /** Graphql filter that will restrict the results of the reference field */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** The GraphQL node that the field suggestions will be fetched from */
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    async openLookupDialog() {
        this.setUiComponentProperties('isReferenceDialogOpen', true);
        lookupDialog(this.screenId, 'info', {
            contextNode: this.getUiComponentProperty('node'),
            createTunnelLinkText: undefined,
            fieldId: this.elementId,
            fieldProperties: this._getUiComponentProperties(this.screenId, this.elementId),
            isLinkCreateNewText: undefined,
            isMultiSelect: false,
            level: undefined,
            onCreateNewItemLinkClick: undefined,
            parentElementId: undefined,
            recordContext: undefined,
            searchText: undefined,
            selectedRecordId: this.value?._id,
            value: this.value,
            valueField: undefined,
        })
            .catch(noop)
            .then(([selection]) => {
            const { dispatch, getState } = getStore();
            handleChange(this.elementId, selection ?? null, async () => {
                await setFieldValue(this.screenId, this.elementId, selection, true)(dispatch, getState);
            }, this.validateWithDetails.bind(this), () => {
                triggerFieldEvent(this.screenId, this.elementId, 'onChange');
            });
        });
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    focus() {
        this._focus();
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], PodControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the value of the pod can be unset */
], PodControlObject.prototype, "canRemove", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], PodControlObject.prototype, "placeholder", void 0);
__decorate([
    ControlObjectProperty()
    /** Lookup Dialog title **/
], PodControlObject.prototype, "lookupDialogTitle", void 0);
//# sourceMappingURL=pod-control-object.js.map