/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { PodProperties } from './pod-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class PodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Pod, FieldComponentProps<FieldKey.Pod>> {
    static readonly defaultUiProperties: Partial<PodProperties<ScreenBase, any>>;
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter<NodeType> | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter<NodeType> | undefined);
    /** The GraphQL node that the field suggestions will be fetched from */
    get node(): string;
    openLookupDialog(): Promise<void>;
    /** The helper text underneath the field */
    helperText?: string;
    /** Whether the value of the pod can be unset */
    canRemove?: boolean;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Lookup Dialog title **/
    lookupDialogTitle?: string;
    refresh(): Promise<void>;
    focus(): void;
}
//# sourceMappingURL=pod-control-object.d.ts.map