import * as React from 'react';
import { connect } from 'react-redux';
import { lookupDialog } from '../../../service/dialog-service';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { calculateContainerWidth } from '../../../utils/responsive-utils';
import { Pod } from '../../ui/pod/pod-component';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
export class PodComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onChange = (collectionItem, isOrganicChange) => {
            if (isOrganicChange) {
                handleChange(this.props.elementId, collectionItem ?? null, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.onRemove = () => handleChange(this.props.elementId, null, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
        this.onNewPod = async () => {
            try {
                const [selectedRecord] = await lookupDialog(this.props.screenId, 'info', {
                    contextNode: this.props.contextNode,
                    createTunnelLinkText: undefined,
                    fieldId: this.props.elementId,
                    fieldProperties: this.props.fieldProperties,
                    isLinkCreateNewText: false,
                    isMultiSelect: false,
                    level: this.props.level,
                    onCreateNewItemLinkClick: undefined,
                    recordContext: this.props.recordContext,
                    selectedRecordId: this.props.value?._id,
                    value: this.props.value,
                });
                this.onChange(selectedRecord, true);
            }
            catch {
                /* intentionally left empty */
            }
            if (this.props.setFieldProperties) {
                this.props.setFieldProperties(this.props.elementId, {
                    ...this.props.fieldProperties,
                    isReferenceDialogOpen: true,
                });
            }
        };
        this.isLookupDialogOpen = () => !!this.props.fieldProperties.isReferenceDialogOpen && !!this.props.fieldProperties.columns;
    }
    render() {
        const { fieldProperties, browser, availableColumns, value, elementId, screenId } = this.props;
        const podWidth = browser && calculateContainerWidth(browser.is, availableColumns || 12, 'small');
        const podProps = {
            availableColumns: podWidth,
            baseAttributesDivWrapper: this.getBaseAttributesDivWrapper('pod', 'e-pod-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested),
            browser,
            contextType: this.props.contextType,
            elementId,
            fieldProperties,
            isDisabled: this.isDisabled(),
            isReadOnly: true,
            onBlockClick: this.getClickHandler(),
            onNewPod: this.onNewPod,
            onRemove: this.onRemove,
            onTelemetryEvent: this.props.fieldProperties.onTelemetryEvent,
            screenId,
            value,
        };
        return React.createElement(Pod, { ...podProps });
    }
}
const mapStateWithTelemetryToProps = () => (state, props) => {
    const componentProps = mapStateToProps()(state, props);
    return {
        ...componentProps,
        fieldProperties: {
            ...componentProps.fieldProperties,
            onTelemetryEvent: state.applicationContext?.onTelemetryEvent,
        },
    };
};
export const ConnectedPodComponent = connect(mapStateWithTelemetryToProps(), mapDispatchToProps())(PodComponent);
//# sourceMappingURL=pod-component.js.map