import * as React from 'react';
import type { ScreenBase } from '../../../service/screen-base';
import type { CollectionItem } from '../../types';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { PodDecoratorProperties } from './pod-types';
export declare class PodComponent extends EditableFieldBaseComponent<PodDecoratorProperties<ScreenBase, any>, any, NestedFieldsAdditionalProperties> {
    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
    onRemove: () => void;
    onNewPod: () => Promise<void>;
    isLookupDialogOpen: () => boolean;
    render(): React.ReactNode;
}
export declare const ConnectedPodComponent: import("react-redux").ConnectedComponent<typeof PodComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<PodComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=pod-component.d.ts.map