/**
 * @packageDocumentation
 * @module root
 * */
import { addColumnsToProperties, addDisabledToProperties, addNodeToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { PodCollectionControlObject } from './pod-collection-control-object';
class PodCollectionDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = PodCollectionControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addNodeToProperties({ dataType, propertyDetails, properties });
        addColumnsToProperties({
            dataType,
            propertyDetails,
            properties,
            dataTypes: this.dataTypes,
            nodeTypes: this.nodeTypes,
        });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [PodCollection]{@link PodCollectionControlObject} field with the provided properties
 *
 * @param properties The properties that the [PodCollection]{@link PodCollectionControlObject} field will be initialized with
 */
export function podCollectionField(properties) {
    // Backwards support of the renamed rowAction property. In case of X3, they may deploy older platform with new app code. We should remove this around August 2023.
    if (properties.rowActions) {
        // eslint-disable-next-line no-param-reassign
        properties = {
            ...properties,
            dropdownActions: properties.rowActions,
        };
    }
    return standardDecoratorImplementation(properties, PodCollectionDecorator, FieldKey.PodCollection);
}
export function podCollectionFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=pod-collection-decorator.js.map