/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { NestedFieldTypes } from '../../nested-fields';
import type { FieldKey } from '../../types';
import { CollectionValueControlObject } from '../collection-value-field';
import type { PodCollectionProperties } from './pod-collection-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
 */
export declare class PodCollectionControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.PodCollection, NestedRecordType, CT, NestedFieldTypes, PodCollectionProperties<CT, NestedRecordType>> {
    canAddRecord?: boolean;
    canRemoveRecord?: boolean;
    addButtonText?: string;
    removeDialogTitle?: string;
    removeDialogText?: string;
    /**
     * Whether the field is editable (isReadOnly = false) or not (isReadOnly = true)
     *
     * The difference with disabled is that isReadOnly suggests that the field is never editable
     * (e.g. the id field of an object)
     */
    isReadOnly: boolean;
    /** Moves the browser focus to this field */
    focus(): void;
    get node(): string;
}
//# sourceMappingURL=pod-collection-control-object.d.ts.map