import * as React from 'react';
import type { OnTelemetryEventFunction } from '../../../redux/state';
import type { CollectionValue } from '../../../service/collection-data-service';
import type { ScreenBase } from '../../../service/screen-base';
import type { NodePropertyType } from '../../../types';
import type { ValueOrCallbackWithFieldValue } from '../../../utils/types';
import type { NestedField, NestedFieldTypes } from '../../nested-fields';
import type { CollectionItem, FieldKey } from '../../types';
import type { CollectionItemActionGroup, CollectionItemActionOrMenuSeparator } from '../../ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { PodCollectionProperties } from './pod-collection-types';
export interface PodCollectionItemProps {
    _id: string;
    additionalTestId?: string;
    canRemoveRecord: boolean;
    canSelectRecord: boolean;
    dropdownActions?: Array<CollectionItemActionOrMenuSeparator<any> | CollectionItemActionGroup<any>>;
    elementId: string;
    getRowValue: () => CollectionItem;
    headerLabel?: NestedField<any, FieldKey.Label>;
    isDisabled: boolean;
    isReadOnly: boolean;
    isSelected: boolean;
    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
    node?: NodePropertyType;
    onPodChange: (bind: string, value: any) => Promise<void>;
    onPodClick: () => void;
    onPodRemoved: () => Promise<void>;
    onPodSelectionChange: (isSelected: boolean) => void;
    onTelemetryEvent?: OnTelemetryEventFunction;
    podWidth: any;
    screenId: string;
    title?: NestedField<ScreenBase, NestedFieldTypes> | ValueOrCallbackWithFieldValue<any, string>;
}
export declare const PodCollectionItem: React.FC<PodCollectionItemProps>;
interface PodCollectionState {
    invalidRecordIds: string[];
    isAddButtonDisabled: boolean;
}
export declare class PodCollectionComponent extends EditableFieldBaseComponent<PodCollectionProperties, CollectionValue, {}, PodCollectionState> {
    constructor(props: BaseEditableComponentProperties<PodCollectionProperties, CollectionValue>);
    shouldComponentUpdate(): boolean;
    private onBlockChange;
    private getRowValue;
    private getChildFields;
    private onPodAdded;
    private onPodRemoved;
    private readonly onPodClick;
    private readonly onPodSelectionChange;
    private readonly isItemSelected;
    getTooltipContent: () => React.ReactNode;
    filterErrors: () => void;
    unFilterErrors: () => void;
    render(): React.ReactNode;
}
export declare const ConnectedPodCollectionComponent: import("react-redux").ConnectedComponent<React.ComponentType<{}>, {
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<{}, any, any>> | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedPodCollectionComponent;
//# sourceMappingURL=pod-collection-component.d.ts.map