import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedPodCollectionComponent = React.lazy(() => import('./pod-collection-component'));
export function AsyncConnectedPodCollectionComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedPodCollectionComponent, { ...props })));
}
const PodCollectionComponent = React.lazy(() => import('./pod-collection-component').then(c => ({ default: c.PodCollectionComponent })));
export function AsyncPodCollectionComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(PodCollectionComponent, { ...props })));
}
//# sourceMappingURL=async-pod-collection-component.js.map