/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { PluginControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class PluginDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = PluginControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
export function pluginField(properties) {
    return standardDecoratorImplementation(properties, PluginDecorator, FieldKey.Plugin);
}
export function pluginFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=plugin-decorator.js.map