import { camelCase } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { errorDialog } from '../../../service/dialog-service';
import { executeGraphqlQuery } from '../../../service/graphql-utils';
import { showToast } from '../../../service/toast-service';
import { Router } from '../../../service/router';
import { notifyConsumerOnError } from '../../../service/telemetry-service';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
export class PluginComponent extends EditableFieldBaseComponent {
    constructor(props) {
        super(props);
        this.setFieldValue = (value) => {
            if (this.props.value !== value) {
                this.handleChange(this.props.elementId, value, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.setFieldProperties = (propertyName, propertyValue) => {
            if (this.props.setFieldProperties) {
                this.props.setFieldProperties(this.props.elementId, {
                    ...this.props.fieldProperties,
                    [propertyName]: propertyValue,
                });
            }
        };
        this.router = new Router(this.props.screenId);
    }
    componentDidCatch(error) {
        errorDialog(this.props.screenId, 'Plugin error', error);
        notifyConsumerOnError(error);
    }
    render() {
        const pluginImplementation = this.props.pluginImplementation;
        const Component = pluginImplementation.component;
        const hasTitle = this.getTitle() && !this.props.fieldProperties.isTitleHidden;
        const hasHelperText = this.props.fieldProperties.helperText && !this.props.fieldProperties.isHelperTextHidden;
        let heightTaken = 24;
        if (heightTaken && hasTitle) {
            heightTaken += 20;
        }
        if (heightTaken && hasHelperText) {
            heightTaken += 16;
        }
        return (React.createElement("div", { ref: this.componentRef, ...this.getBaseAttributesDivWrapper('plugin', `e-plugin-field e-plugin-field-type-${camelCase(pluginImplementation.name)}`, this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested) },
            hasTitle && React.createElement(FieldLabel, { label: this.getTitle() }),
            React.createElement("div", { className: "e-plugin-container", style: {
                    '--height-taken': heightTaken ? `${heightTaken}px` : '0px',
                } },
                React.createElement(Component, { browser: this.props.browser, elementId: this.props.elementId, executeQuery: (query) => executeGraphqlQuery({ query }), fieldProperties: this.props.fieldProperties, locale: this.props.locale, queryParameters: this.props.queryParameters, router: this.router, screenId: this.props.screenId, setFieldProperty: this.setFieldProperties, setFieldValue: this.setFieldValue, showToast: showToast, username: this.props.username, value: this.props.value || null })),
            hasHelperText && React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText })));
    }
}
const extendedMapStateToProps = (state, props) => {
    const componentProperties = mapStateToProps()(state, props);
    const screenDefinition = state.screenDefinitions[props.screenId];
    return {
        ...props,
        ...componentProperties,
        username: state.applicationContext.login,
        pluginImplementation: state.plugins[componentProperties.fieldProperties.pluginPackage],
        queryParameters: screenDefinition.queryParameters,
    };
};
export const ConnectedPluginComponent = connect(extendedMapStateToProps, mapDispatchToProps())(PluginComponent);
export default ConnectedPluginComponent;
//# sourceMappingURL=plugin-component.js.map