import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { NumericControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
import { addDisabledToProperties, addMaxMinToProperties, addScaleToProperties } from '../../../utils/data-type-utils';
class NumericDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = NumericControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addScaleToProperties({ dataType, propertyDetails, properties });
        addMaxMinToProperties({ dataType, propertyDetails, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [Numeric]{@link NumericControlObject} field with the provided properties
 *
 * @param properties The properties that the [Numeric]{@link NumericControlObject} field will be initialized with
 */
export function numericField(properties) {
    return standardDecoratorImplementation(properties, NumericDecorator, FieldKey.Numeric);
}
export function numericFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=numeric-decorator.js.map