import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { NumericDecoratorProperties } from './numeric-types';
/**
 * Initializes the decorated member as a [Numeric]{@link NumericControlObject} field with the provided properties
 *
 * @param properties The properties that the [Numeric]{@link NumericControlObject} field will be initialized with
 */
export declare function numericField<T extends ScreenExtension<T>>(properties: NumericDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function numericFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<NumericDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=numeric-decorator.d.ts.map