/**
 * @packageDocumentation
 * @module root
 * */
import type { Unit } from '@sage/xtrem-shared';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { UnitMode } from '../traits';
/**
 * [Field]{@link EditableFieldControlObject} that contains a numeric value
 */
export declare class NumericControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Numeric, FieldComponentProps<FieldKey.Numeric>> {
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /**
     * Number of digits after the numeric field value decimal point.
     * Must be in the range 0 - 20, inclusive.
     */
    scale?: number;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /** The maximum value allowed for the numeric field */
    max?: number;
    /** The minimum value allowed for the numeric field */
    min?: number;
    /** The helper text underneath the field */
    placeholder?: string;
    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
    isNotZero?: boolean;
    /** Unit of measure, if set the prefix/postfix and the scale is automatically set based on the user's locale */
    unit?: Unit | null;
    /** When the unit is set, this mode determines whether the unit should be handled as a unit of measure or a currency. Defaults to 'currency'. */
    unitMode?: UnitMode;
    /** Increment value which is set by the stepper buttons. If no increment value is defined or it is set to zero, then the stepper buttons are not rendered. */
    stepIncrement?: number;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=numeric-control-object.d.ts.map