import React from 'react';
import type { CellParams } from '../../../utils/ag-grid/ag-grid-column-config';
import type { NestedNumericProperties } from '../../nested-fields-properties';
import { RecordActionType } from '../../../service/collection-data-types';
interface NumericEditorState {
    value: string;
    highlightOnFocus: boolean;
    hasUserModifiedValue: boolean;
}
export default class NumericEditor extends React.Component<CellParams<NestedNumericProperties>, NumericEditorState> {
    private readonly input;
    private valueChangeSubscription;
    constructor(props: CellParams<NestedNumericProperties>);
    componentDidMount(): void;
    componentWillUnmount(): void;
    onChange(event: React.ChangeEvent<HTMLInputElement>): void;
    onKeyDown(event: React.KeyboardEvent<HTMLInputElement>): void;
    onExternalValueChange: (type: RecordActionType, rowValue: any) => void;
    render(): React.ReactNode;
}
export {};
//# sourceMappingURL=numeric-cell-editor.d.ts.map