import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedNumericComponent = React.lazy(() => import('./numeric-component'));
export function AsyncConnectedNumericComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedNumericComponent, { ...props })));
}
const NumericComponent = React.lazy(() => import('./numeric-component').then(c => ({ default: c.NumericComponent })));
export function AsyncNumericComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(NumericComponent, { ...props })));
}
//# sourceMappingURL=async-numeric-component.js.map