/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenBaseGenericType, ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldKey, FieldComponentProps } from '../../types';
import type { NodeBrowserTreeDecoratorProperties } from './node-browser-tree-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
 */
export declare class NodeBrowserTreeControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.NodeBrowserTree, FieldComponentProps<FieldKey.NodeBrowserTree>> {
    static readonly defaultUiProperties: Partial<NodeBrowserTreeDecoratorProperties>;
    node: keyof ScreenBaseGenericType<CT>;
}
//# sourceMappingURL=node-browser-tree-control-object.d.ts.map