import Button from 'carbon-react/esm/components/button';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import { get } from 'lodash';
import React from 'react';
import { localize } from '../../../service/i18n-service';
import { getCardDefinitionFromColumns } from '../../../utils/table-component-utils';
import { getFieldTitle } from '../carbon-helpers';
import { useDeepCompareMemo } from '@sage/xtrem-ui-components';
export function MobileNestedGridHeader({ currentLevel, currentLevelObject, elementId, fieldProperties, isTitleHidden, onBackButtonClick, openSidebar, parentByLevel, parentLevelObject, screenId, getTitlePath, }) {
    const parentNestedFields = useDeepCompareMemo(() => getCardDefinitionFromColumns({
        columns: parentLevelObject?.columns,
        mobileCard: fieldProperties.mobileCard,
        screenId,
        isGreaterThanSmall: false,
    }), [parentLevelObject?.columns, fieldProperties.mobileCard, screenId]);
    const titleBind = useDeepCompareMemo(() => (currentLevel > 0 ? getTitlePath(parentNestedFields.title?.properties) : undefined), [currentLevel, getTitlePath, parentNestedFields.title?.properties]);
    const headerTitle = useDeepCompareMemo(() => currentLevel === 0 && fieldProperties.title && !isTitleHidden
        ? getFieldTitle(screenId, fieldProperties, null)
        : null, [currentLevel, fieldProperties, isTitleHidden, screenId]);
    const childTitle = useDeepCompareMemo(() => (titleBind ? get(parentByLevel[currentLevel - 1], titleBind) : null), [currentLevel, parentByLevel, titleBind]);
    const addItemUsingSidebarLabel = localize('@sage/xtrem-ui/add-item-in-line-using-sidebar', 'Add item in sidebar');
    const onAddLineInSidebar = useDeepCompareMemo(() => () => {
        openSidebar({
            screenId,
            elementId,
            level: currentLevel,
            parentId: parentByLevel[currentLevel - 1]?._id,
            fieldProperties,
        });
    }, [currentLevel, elementId, fieldProperties, openSidebar, parentByLevel, screenId]);
    return (React.createElement("div", { "data-testid": "e-mobile-nested-grid-header", className: "e-nested-grid-mobile-header" },
        React.createElement("div", { className: "e-nested-grid-mobile-header-left-container" },
            headerTitle && (React.createElement("span", { "data-testid": "e-mobile-nested-grid-header-title", className: "e-nested-grid-mobile-header-text" }, headerTitle)),
            currentLevel > 0 && (React.createElement(ButtonMinor, { "data-testid": "e-mobile-nested-grid-header-back-button", iconType: "arrow_left", onClick: onBackButtonClick, buttonType: "tertiary", size: "large" })),
            childTitle && (React.createElement("span", { "data-testid": "e-mobile-nested-grid-header-child-title", className: "e-nested-grid-mobile-header-text" }, childTitle))),
        React.createElement("div", { className: "e-mobile-nested-grid-header-right-container" },
            currentLevelObject.canAddNewLine && currentLevelObject.sidebar && (React.createElement(Button, { "aria-label": addItemUsingSidebarLabel, buttonType: "primary", className: "e-nested-grid-button-add-new-row-sidebar", "data-pendoid": `addNestedGridLineWithSidebarButton-${screenId}-${elementId}-level-${currentLevel}`, "data-testid": "e-nested-grid-button-add-new-row-sidebar", disabled: parentLevelObject?.isDisabled || currentLevelObject.isDisabled, iconType: "add", onClick: onAddLineInSidebar }, addItemUsingSidebarLabel)),
            React.createElement("span", { "data-testid": "e-mobile-grid-header-level", className: "e-nested-grid-mobile-header-text" },
                currentLevel + 1,
                "/",
                fieldProperties.levels.length))));
}
//# sourceMappingURL=mobile-nested-grid-header.js.map