import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedNestedGridComponent = React.lazy(() => import('./nested-grid-component'));
export function AsyncConnectedNestedGridComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedNestedGridComponent, { ...props })));
}
const NestedGridComponent = React.lazy(() => import('./nested-grid-component').then(c => ({ default: c.NestedGridComponent })));
export function AsyncNestedGridComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(NestedGridComponent, { ...props })));
}
//# sourceMappingURL=async-nested-grid-component.js.map