import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { useDispatch } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { getElementAccessStatusWithoutId } from '../../../utils/access-utils';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
const ConnectedMultiReferenceComponent = React.lazy(() => import('./multi-reference-component'));
export function AsyncConnectedMultiReferenceComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedMultiReferenceComponent, { ...props })));
}
const MultiReferenceComponent = React.lazy(() => import('./multi-reference-component').then(c => ({ default: c.MultiReferenceComponent })));
export function AsyncMultiReferenceComponent(props) {
    const dispatch = useDispatch();
    const openTunnel = React.useCallback(async () => dispatch(xtremRedux.actions.openTunnel({
        screenId: props.screenId,
        elementId: props.elementId,
        fieldProperties: props.fieldProperties,
        parentElementId: props.parentElementId,
        recordContext: props.recordContext,
        contextNode: props.contextNode,
        value: props.value,
    })), [dispatch, props]);
    const screenDefinition = useDeepEqualSelector(s => s.screenDefinitions[props.screenId]);
    const hasAccessToTunnelPage = !!props.fieldProperties.tunnelPage &&
        getElementAccessStatusWithoutId(screenDefinition.accessBindings, {
            node: String(props.fieldProperties.node),
            bind: '$read',
        }) === 'authorized';
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(MultiReferenceComponent, { ...props, fieldProperties: {
                ...props.fieldProperties,
                helperTextField: props.fieldProperties.helperTextField,
                imageField: props.fieldProperties.imageField,
                valueField: props.fieldProperties.valueField,
            }, openTunnel: openTunnel, hasAccessToTunnelPage: hasAccessToTunnelPage })));
}
//# sourceMappingURL=async-multi-reference-component.js.map