/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { NestedFieldTypes } from '../../nested-fields';
import type { FieldKey, AttachmentAssociation } from '../../types';
import { CollectionValueControlObject } from '../collection-value-field';
import type { MultiFileDepositProperties } from './multi-file-deposit-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
 */
export declare class MultiFileDepositControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.MultiFileDeposit, AttachmentAssociation, CT, NestedFieldTypes, MultiFileDepositProperties<CT>> {
    canAddRecord?: boolean;
    canRemoveRecord?: boolean;
    /**
     * Whether the field is editable (isReadOnly = false) or not (isReadOnly = true)
     *
     * The difference with disabled is that isReadOnly suggests that the field is never editable
     * (e.g. the id field of an object)
     */
    isReadOnly: boolean;
    /** Moves the browser focus to this field */
    focus(): void;
    get node(): string;
    addFiles(_files: File[]): Promise<void>;
}
//# sourceMappingURL=multi-file-deposit-control-object.d.ts.map