import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentProperties, MultiFileDepositDecoratorProperties, WithCancelToken } from './multi-file-deposit-types';
import type { AttachmentAssociation } from '../../types';
import { ContextType } from '../../../types';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { CollectionValue } from '../../../service/collection-data-service';
interface MultiFileDepositComponentState {
    hasValue: boolean;
    isFileInputVisible: boolean;
    selectedItem: AttachmentAssociation | undefined;
}
export declare class MultiFileDepositComponent extends EditableFieldBaseComponent<MultiFileDepositDecoratorProperties, CollectionValue<WithCancelToken<AttachmentAssociation>>, MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentState> {
    private changeSubscription;
    constructor(props: MultiFileDepositComponentProperties);
    getDefaultStateFromProps(props: MultiFileDepositComponentProperties): MultiFileDepositComponentState;
    componentDidUpdate(prevProps: BaseEditableComponentProperties<MultiFileDepositDecoratorProperties, CollectionValue<WithCancelToken<AttachmentAssociation>>, MultiFileDepositComponentAdditionalProperties>): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    isPreviewInPopup: () => boolean;
    onChange: (fileList: FileList) => Promise<void>;
    cancelFileUploading: (recordId: string) => void;
    getPreviewFixedHeight: () => number | undefined;
    getUploadAreaHeight: () => string;
    displayCancelUploadDialog(recordId: string): Promise<void>;
    displayRemoveFileDialog(recordId: string): Promise<void>;
    onToggleDropzone: () => void;
    onClosePreview: () => void;
    onRowClick: (selectedItem: AttachmentAssociation) => void;
    onPreviewDialogOpen: (selectedItem: AttachmentAssociation) => void;
    onEditDetails: (selectedItem: AttachmentAssociation) => void;
    renderUploadedFilesTable: () => React.ReactElement | null;
    renderPreviewComponentInDialog(): React.ReactElement;
    renderPreviewComponent(): React.ReactElement;
    renderTableAndPreview: () => React.ReactElement;
    render(): React.ReactElement;
}
export declare const ConnectedMultiFileDepositComponent: import("react-redux").ConnectedComponent<typeof MultiFileDepositComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<MultiFileDepositComponent> | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedMultiFileDepositComponent;
//# sourceMappingURL=multi-file-deposit-component.d.ts.map