import { addDisabledToProperties, addOptionTypeToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { MultiDropdownControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class MultiDropdownDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = MultiDropdownControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addOptionTypeToProperties({ propertyDetails, dataType, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [MultiDropdown]{@link MultiDropdownControlObject} field with the provided properties
 *
 * @param properties The properties that the [MultiDropdown]{@link MultiDropdownControlObject} field will be initialized with
 */
export function multiDropdownField(properties) {
    return standardDecoratorImplementation(properties, MultiDropdownDecorator, FieldKey.MultiDropdown);
}
export function multiDropdownFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=multi-dropdown-decorator.js.map