/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
 */
export declare class MultiDropdownControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.MultiDropdown, FieldComponentProps<FieldKey.MultiDropdown>> {
    /** The helper text underneath the field */
    helperText?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /** Indicator, whether sounds play on successful/erroneous selection */
    isSoundDisabled?: boolean;
    /** Options to be displayed in the MultiDropdown element */
    options?: string[];
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /**  The minimum number of items that has to be selected*/
    minItems?: number;
    /**  The maximum number of items that has to be selected*/
    maxItems?: number;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=multi-dropdown-control-object.d.ts.map