import * as React from 'react';
import { connect } from 'react-redux';
import { ContextType } from '../../../types';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { addOptionsAndLocalizationToProps, splitValueToMergedValue } from '../../../utils/transformers';
import { Select } from '../../ui/select/select-component';
import { getCommonCarbonComponentProperties, getLabelTitle } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { createSelectItemFromOption, getItemsFromProps } from '../select/select-utils';
export class MultiDropdownComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onChange = (items) => {
            handleChange(this.props.elementId, items.map(v => v.id), this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
        };
        this.getBorderColor = () => {
            return this.props.contextType === ContextType.pod ? 'transparent' : undefined;
        };
        this.getItems = (searchText) => {
            if (this.props.fieldProperties.optionType) {
                return getItemsFromProps(this.props, searchText, splitValueToMergedValue(this.props.recordContext));
            }
            if (this.props.fieldProperties.options) {
                const options = resolveByValue({
                    propertyValue: this.props.fieldProperties.options,
                    screenId: this.props.screenId,
                    skipHexFormat: true,
                    fieldValue: this.props.value,
                    rowValue: this.props.recordContext,
                });
                return options.map(option => createSelectItemFromOption(option, this.props));
            }
            return [];
        };
        this.getReadOnlyValue = () => {
            const value = this.props.value || [];
            const items = this.getItems();
            return value.map(v => items.find(i => i.id === v)?.displayedAs).join(', ');
        };
    }
    render() {
        const carbonProps = getCommonCarbonComponentProperties(this.props);
        const value = this.props.value
            ? this.props.value.map(v => createSelectItemFromOption(v, this.props))
            : undefined;
        const label = !this.props.fieldProperties.isTitleHidden
            ? getLabelTitle(this.props.screenId, this.props.fieldProperties, this.props.handlersArguments?.rowValue)
            : undefined;
        const { fieldProperties: { isFullWidth, icon, placeholder, helperText, size }, validationErrors, onFocus, handlersArguments, } = this.props;
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-multi-dropdown-field", componentName: "multi-dropdown", componentRef: this.componentRef, handlersArguments: handlersArguments, helperText: helperText, noReadOnlySupport: true, value: this.props.value, readOnlyDisplayValue: this.getReadOnlyValue() },
            React.createElement(Select, { ...carbonProps, autoSelect: false, borderColor: this.getBorderColor(), disabled: this.isDisabled(), disablePills: true, hasInputSearch: false, error: validationErrors?.[0]?.message, fullWidth: isFullWidth, getItems: (searchText) => Promise.resolve(this.getItems(searchText)), helperText: helperText, icon: icon, inputId: carbonProps.id, label: label, initialSelectedItems: value, isSortedAlphabetically: this.props.fieldProperties.isSortedAlphabetically, selectedItems: value, isMultiSelect: true, minLookupCharacters: 0, onSelectedItemsChange: this.onChange, onInputFocus: onFocus, placeholder: placeholder, readOnly: this.isReadOnly(), size: size, testId: "e-multi-dropdown-field-input", screenId: this.props.screenId, elementId: this.props.elementId, isSoundDisabled: resolveByValue({
                    screenId: this.props.screenId,
                    propertyValue: this.props.fieldProperties.isSoundDisabled,
                    skipHexFormat: true,
                    fieldValue: null,
                    rowValue: null,
                }) })));
    }
}
export const ConnectedMultiDropdownComponent = connect((state, externalProps) => addOptionsAndLocalizationToProps(state, mapStateToProps()(state, externalProps)), mapDispatchToProps())(MultiDropdownComponent);
export default ConnectedMultiDropdownComponent;
//# sourceMappingURL=multi-dropdown-component.js.map