/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { MessageControlObject } from './message-control-object';
class MessageDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = MessageControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
export function messageField(properties) {
    return standardDecoratorImplementation(properties, MessageDecorator, FieldKey.Message);
}
export function messageFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=message-decorator.js.map