import { resolveByValue } from '../../../utils/resolve-value-utils';
export const getQueryParameters = (screenId, fieldProperties, fieldValue, rowValue) => {
    return resolveByValue({
        screenId,
        propertyValue: fieldProperties.queryParameters,
        rowValue,
        fieldValue,
        skipHexFormat: true,
    });
};
export const getQueryParametersAsString = (screenId, fieldProperties, fieldValue, rowValue) => {
    const queryParameters = getQueryParameters(screenId, fieldProperties, fieldValue, rowValue);
    if (!queryParameters) {
        return '';
    }
    return btoa(JSON.stringify(queryParameters));
};
export const getPage = (screenId, fieldProperties, fieldValue, rowValue) => {
    return resolveByValue({
        screenId,
        propertyValue: fieldProperties.page,
        rowValue,
        fieldValue,
        skipHexFormat: true,
    });
};
export const getTextLink = (screenId, fieldProperties, fieldValue, rowValue) => {
    const queryParameters = getQueryParametersAsString(screenId, fieldProperties, fieldValue, rowValue);
    const page = getPage(screenId, fieldProperties, fieldValue, rowValue);
    if (!queryParameters) {
        return page || '#';
    }
    return page ? `${page}/${queryParameters}` : '#';
};
//# sourceMappingURL=link-utils.js.map