/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { LinkControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class LinkDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = LinkControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Link]{@link LinkControlObject} field with the provided properties
 *
 * @param properties The properties that the [Link]{@link LinkControlObject} field will be initialized with
 */
export function linkField(properties) {
    return standardDecoratorImplementation(properties, LinkDecorator, FieldKey.Link);
}
export function linkFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=link-decorator.js.map