import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { QueryParameters } from '../../../utils/types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a link to another page
 */
export declare class LinkControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Link, FieldComponentProps<FieldKey.Link>> {
    /** The page to navigate to on link click */
    page?: string;
    queryParameters?: QueryParameters;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=link-control-object.d.ts.map