import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedLinkComponent = React.lazy(() => import('./link-component'));
export function AsyncConnectedLinkComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedLinkComponent, { ...props })));
}
const LinkComponent = React.lazy(() => import('./link-component').then(c => ({ default: c.LinkComponent })));
export function AsyncLinkComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(LinkComponent, { ...props })));
}
//# sourceMappingURL=async-link-component.js.map