/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { FieldControlObjectResolvedProperty } from '../../property-decorators/control-object-resolved-property-decorator';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a read-only text value
 */
export class LabelControlObject extends ReadonlyFieldControlObject {
    /** Field's value, only valid options can be set as value. */
    set value(newValue) {
        this._setValue(newValue);
    }
    /** Field's value, only valid options can be set as value. */
    get value() {
        return this._getValue() || null;
    }
}
__decorate([
    FieldControlObjectResolvedProperty()
    /** The border color of the label */
], LabelControlObject.prototype, "borderColor", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** The background color of the HTML field */
], LabelControlObject.prototype, "backgroundColor", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** The font color of the HTML field */
], LabelControlObject.prototype, "color", void 0);
__decorate([
    ControlObjectProperty()
    /** Text to be displayed inline after the field value */
], LabelControlObject.prototype, "prefix", void 0);
__decorate([
    ControlObjectProperty()
    /** Text to be displayed inline before the field value */
], LabelControlObject.prototype, "postfix", void 0);
//# sourceMappingURL=label-control-object.js.map