import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedLabelComponent = React.lazy(() => import('./label-component'));
export function AsyncConnectedLabelComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedLabelComponent, { ...props })));
}
const LabelComponent = React.lazy(() => import('./label-component').then(c => ({ default: c.LabelComponent })));
export function AsyncLabelComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(LabelComponent, { ...props })));
}
//# sourceMappingURL=async-label-component.js.map