/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ImageControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ImageDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = ImageControlObject;
    }
}
/**
 * Initializes the decorated member as a [Image]{@link ImageControlObject} field with the provided properties
 *
 * @param properties The properties that the [Image]{@link ImageControlObject} field will be initialized with
 */
export function imageField(properties) {
    return standardDecoratorImplementation(properties, ImageDecorator, FieldKey.Image);
}
export function imageFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=image-decorator.js.map