/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { ImageDecoratorProperties } from './image-types';
/**
 * Initializes the decorated member as a [Image]{@link ImageControlObject} field with the provided properties
 *
 * @param properties The properties that the [Image]{@link ImageControlObject} field will be initialized with
 */
export declare function imageField<T extends ScreenExtension<T>>(properties: ImageDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function imageFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<ImageDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=image-decorator.d.ts.map