import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { ImageComponentProps, ImageComponentState, ImageValue, ImageDecoratorProperties } from './image-types';
import { ContextType } from '../../../types';
export declare class ImageComponent extends EditableFieldBaseComponent<ImageDecoratorProperties, ImageValue, NestedFieldsAdditionalProperties, ImageComponentState> {
    private readonly fileRef;
    constructor(props: ImageComponentProps);
    private readFile;
    private readonly getPlaceholderValue;
    private readonly getPlaceholderMode;
    private readonly onDragOver;
    private readonly onDrop;
    private readonly onCreateElementClick;
    private readonly onFileChanged;
    private readonly onRemoveImage;
    private readonly onFullScreenOpen;
    private readonly onFullScreenClose;
    private readonly renderRemoveIcon;
    private readonly renderReadOnlyPlaceholder;
    private readonly renderValueBody;
    private readonly renderFullScreenView;
    private renderUploadArea;
    render(): React.ReactNode;
}
export declare const ConnectedImageComponent: import("react-redux").ConnectedComponent<typeof ImageComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ImageComponent> | undefined;
    contextType?: ContextType | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedImageComponent;
//# sourceMappingURL=image-component.d.ts.map