/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { IconDecoratorProperties } from './icon-types';
/**
 * Initializes the decorated member as a [Icon]{@link IconControlObject} field with the provided properties
 *
 * @param properties The properties that the [Icon]{@link IconControlObject} field will be initialized with
 */
export declare function iconField<T extends ScreenExtension<T>>(properties: IconDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function iconFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<IconDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=icon-decorator.d.ts.map