/**
 * @packageDocumentation
 * @module root
 * */
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { ScreenExtension } from '../../../types';
import type { ScreenBase } from '../../../service/screen-base';
import type { IconBackgroundShape, IconBackgroundSize } from './icon-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a graphic icon
 */
export declare class IconControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Icon, FieldComponentProps<FieldKey.Icon>> {
    /** The background color of the HTML field */
    backgroundColor?: string;
    /** The font color of the HTML field */
    color?: string;
    /** The background shape of the icon */
    backgroundShape?: IconBackgroundShape;
    /** The background shape of the icon */
    backgroundSize?: IconBackgroundSize;
}
//# sourceMappingURL=icon-control-object.d.ts.map