import * as React from 'react';
import { connect } from 'react-redux';
import { ContextType } from '../../../types';
import { Icon } from '../../ui/icon/icon-component';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { mapReadonlyStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
export class IconComponent extends ReadonlyFieldBaseComponent {
    getIconElement() {
        const classNames = ['e-field-value'];
        const title = this.getTitle() || '';
        if (this.props.fieldProperties.onClick) {
            classNames.push('e-icon-clickable');
        }
        const style = this.getResolvedProperty('style', true);
        return (React.createElement(Icon, { className: classNames.join(' '), 
            // TODO: Type "color" and "backgroundColor" based on the field type
            // The Carbon library only supports some values here, the functional developer has to be aware
            bg: style?.backgroundColor ?? this.getResolvedProperty('backgroundColor', false), bgShape: this.getResolvedProperty('backgroundShape', true), bgSize: this.getResolvedProperty('backgroundSize', true), color: style?.iconColor ?? this.getResolvedProperty('color', false), fontSize: this.getResolvedProperty('iconSize', true) || 'small', onClick: this.getClickHandler(), type: this.getValue() || 'none', "aria-label": title, tooltipMessage: this.props.fieldProperties.onClick ? title : undefined }));
    }
    render() {
        const { isTitleHidden, isHelperTextHidden } = this.props.fieldProperties;
        const isFieldLabelHidden = !!isTitleHidden || (this.props.isNested && !this.props.shouldRenderLabelInNestedReadOnlyMode);
        const isFieldHelperTextHidden = isHelperTextHidden || this.props.nestedReadOnlyField;
        return (React.createElement("div", { ...this.getBaseAttributesDivWrapper('icon', 'e-icon-field', this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested) },
            this.props.contextType !== ContextType.navigationPanel && !isFieldLabelHidden && (React.createElement(FieldLabel, { label: this.getTitle() })),
            this.getIconElement(),
            this.props.contextType !== ContextType.navigationPanel && !isFieldHelperTextHidden && (React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText }))));
    }
}
export const ConnectedIconComponent = connect(mapReadonlyStateToProps())(IconComponent);
export default ConnectedIconComponent;
//# sourceMappingURL=icon-component.js.map