import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedIconComponent = React.lazy(() => import('./icon-component'));
export function AsyncConnectedIconComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedIconComponent, { ...props })));
}
const IconComponent = React.lazy(() => import('./icon-component').then(c => ({ default: c.IconComponent })));
export function AsyncIconComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(IconComponent, { ...props })));
}
//# sourceMappingURL=async-icon-component.js.map