/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FormDesignerControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class FormDesignerDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = FormDesignerControlObject;
    }
}
/**
 * Initializes the decorated member as a [FormDesigner]{@link FormDesignerControlObject} field with the provided properties
 *
 * @param properties The properties that the [FormDesigner]{@link FormDesignerControlObject} field will be initialized with
 */
export function formDesignerField(properties) {
    return standardDecoratorImplementation(properties, FormDesignerDecorator, FieldKey.FormDesigner, true);
}
export function formDesignerFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=form-designer-decorator.js.map