import type { FilterParameter } from '@sage/xtrem-ui-components';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { PaperOrientation, PaperSize } from '@sage/xtrem-document-editor';
export declare class FormDesignerControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FormDesigner, FieldComponentProps<FieldKey.FormDesigner>> {
    /** Document editor parameters */
    parameters: FilterParameter[];
    /** Paper orientation of the editor view, defaults to portrait */
    paperOrientation: PaperOrientation;
    /** Paper size of the editor view, defaults to A4 */
    paperSize: PaperSize;
    /** HTML content of the header */
    headerValue: string;
    /** HTML content of the footer */
    footerValue: string;
    /** Top margin in centimeters */
    marginTop: number;
    /** Bottom margin in centimeters */
    marginBottom: number;
    /** Right margin in centimeters */
    marginRight: number;
    /** Left margin in centimeters */
    marginLeft: number;
    executeEditorCommand(command: string, ...args: any[]): void;
}
//# sourceMappingURL=form-designer-control-object.d.ts.map